set sql_safe_updates=0;

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='PROGRAM_WISE_APPLICATION_APPROVAL_INFO');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T5.id AS ID,
    T6.code AS APPLICATION_CODE,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
  (Case when T8.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T8.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T8.logoUrl)end) as LOGO_URL,
    (Case when T8.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.headerUrl) 
    else NULL end) as HEADER_URL,
    (Case when T8.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T8.footerUrl)
  else NULL end) as FOOTER_URL,
DATE_FORMAT(T11.admissionOfferStartDate, '%d/%m/%Y') AS ADMISSION_OFFER_START_DATE
FROM
    application_program T5
        LEFT JOIN
    application T6 ON T6.id = T5.applicationId
        LEFT JOIN
    applicant_person T7 ON T7.id = T6.applicantPersonId
        LEFT JOIN
    academy_location T8 ON T8.id = T5.academyLocationId
    LEFT JOIN
    organizations org on org.id = 1
  LEFT JOIN
  prog_batch_seat_config T9 on T5.progBatchSeatConfigId = T9.id
    LEFT JOIN
  program_selection_process T10 on T10.programBatchSeatConfigId = T5.progBatchSeatConfigId
    LEFT JOIN
  prog_slctn_process_admisn_conf T11 on T11.programSelectionProcessId = T10.id
WHERE
    T5.id IN (namedParams)",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "APPLICATION_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "LOGO_URL",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "HEADER_URL",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "FOOTER_URL",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "Admission Offer Start Date",
            "resultKey": "ADMISSION_OFFER_START_DATE",
            "displayCode": "",
            "displayOrder": 8
        }]
}' WHERE `dataProviderId` = @sgAppointmentDT;

set sql_safe_updates=1;